

#
# bin_set  : a proc to set/get values in (sub)arrays
#

# example of use
#
# bin_new o obj [bin_sizeof int]+3*[bin_sizeof double];
# bin_def o i int 0 ; # o(i) is a single integer
# bin_def o td double [bin_sizeof int] 3 ;  # o(td) is an array of 3 doubles
# bin_set o(td) 0 1.23  ; # sets double value at pos 0 in sub array td
# puts [bin_set o(td) 0]; # gets value
# set o(i) -1 ;
# puts [bin_set o(i) _str_]; # get special objects tags (here string dump)
# ...

proc bin_set {arrayname index args} {
  upvar $arrayname array;

  if {[catch {bin_info -type array} type]} {
    error "\"$arrayname\" is not an object"
  }

  bin_new ptr $type [bin_sizeof array] array 0 nau ;

  eval set ptr($index) $args;
}

