/*
 * Adonis project TCL software utilities:
 *  Binary data handling in tcl
 *  written by L. Demailly
 *  (c) 1994 Observatoire de Paris - Meudon - France
 *
 * $Id: bindata.h,v 1.27 1997/01/29 23:40:12 dl Exp $ 
 *
 * Description : associate binary object to tcl
 *
 * $Log: bindata.h,v $
 * Revision 1.27  1997/01/29 23:40:12  dl
 * increased version to 1.2
 *
 * Revision 1.26  1997/01/27 22:13:01  dl
 * always use binconf.h
 * added _BIN_GETGLOBALOBJECT macro for tip
 *
 * Revision 1.25  1997/01/26 23:26:53  dl
 * added (empty) test for HAVE_MEMSET
 *
 * Revision 1.24  1996/06/25 08:14:19  dl
 * stick to 80 cols max file.  added a lot of CONST in prototypes
 * and an #ifdef DISCARD_CONST to avoid compilation warnings with current tcl
 *
 * Revision 1.23  1996/05/30  10:56:52  dl
 * new Bin_SizeofType
 *
 * Revision 1.22  1996/05/10  19:56:00  dl
 * no more Bin_NameObject. replaced by Bin_TclAttach
 *
 * Revision 1.21  1996/05/10  16:52:52  dl
 * binconf.h conditional inclusion
 *
 * Revision 1.20  1996/05/08  15:08:42  dl
 * improved comments on Bin_Object structure
 *
 * Revision 1.19  1996/05/07  21:57:05  dl
 * Added new Bin_NameObject
 *
 * Revision 1.18  1996/05/06  21:08:21  dl
 * Bin_Def 1st arg is now directly a Tcl_HashTable pointer instead of anonymous
 * ClientData
 *
 * Revision 1.17  1996/05/06  19:02:22  dl
 * new Bin_GetTHT . can now move met_new creation outside Bin_Init
 *
 * Revision 1.16  1996/05/03  14:33:22  dl
 * added pointer type cast to avoid compiler warnings
 *
 * Revision 1.15  1996/05/03  12:56:34  dl
 * added autoconf test #if for malloc.h, stdlib.h and memory.h
 *
 * Revision 1.14  1996/05/02  23:56:55  dl
 * using standard autoconf defines for ltoa and memmove
 *
 * Revision 1.13  1996/05/02  20:30:41  dl
 * dropped the NO_TCLX compile flag which was not needed in fact (only tcl.h)
 *
 * Revision 1.12  1996/05/02  20:07:06  dl
 * added version defines
 *
 * Revision 1.11  1996/05/02  11:40:04  dl
 * added Bin_TraceNetInt & Bin_TraceNetShort
 *
 * Revision 1.10  1996/04/16  14:03:55  dl
 * huge problem for host without memmove : bcopy args need to be reversed!
 *
 * Revision 1.9  1995/10/27  14:19:49  dl
 * added NO_MEMMOVE define (-> bcopy) and stdlib.h and memory.h include
 * for sunos compat.  changed NOTCLX into NO_TCLX
 *
 * Revision 1.8  1995/09/29  16:21:43  dl
 * added NOTCLX option to include tcl.h instead of tclExtend.h
 *
 * Revision 1.7  1995/08/11  14:39:10  dl
 * added conditional ltoa prototype
 *
 * Revision 1.6  1995/08/10  12:03:21  dl
 * Added Bin_ResizeCmd prototype
 *
 * Revision 1.5  1994/12/31  19:51:29  dl
 * added bin_info et complex type
 *
 * Revision 1.4  1994/11/21  21:20:42  dl
 * added father/print struct in object, bin_move, Bin_FreeChild,Bin8DeleteObject,
 * ...
 *
 * Revision 1.3  1994/11/08  23:55:48  dl
 * better error handling - new unified object trace proc calling,
 * so getobject also works with sub fields.
 *
 * Revision 1.2  1994/11/08  18:14:43  dl
 * added prototypes for copy,read,write, trace short, getobj*...
 *
 * Revision 1.1  1994/10/31  23:37:41  dl
 * Initial revision
 *
 *
 */

#ifndef _BINDATA_INCLUDED
#define _BINDATA_INCLUDED

#ifdef ADONIS
#  ifdef HAVE_CONFIG_H
#    include "binconf.h"
#  endif
#else
/* let's always include binconf.h so we are sure we get the proper values
   in synch with the lib (even if users' project don't define HAVE_CONFIG_H :*/
#    include "binconf.h"
#endif

#include "tcl.h"

#ifdef HAVE_STDIO_H
#  include <stdio.h>
#endif
#ifdef HAVE_MALLOC_H
#  include <malloc.h>
#endif
#ifdef HAVE_STDLIB_H
#  include <stdlib.h>
#endif
#ifdef HAVE_MEMORY_H
#  include <memory.h>
#endif

#define BIN_VERSION_STR        "1.2"
#define BIN_MAJOR_VERSION  1
#define BIN_MINOR_VERSION  2

#ifdef DISCARD_CONST
/* because Tcl miss the CONST in it's prototypes, to avoid a lot of 
warning: passing arg x of `Tcl_xxx' discards `const' from pointer target type
   we 'forget' about const for building bindata.o while we keep it for
   the rest (this will hopefully be changed in later Tcl versions ?) */
#	undef CONST
#	define CONST
#endif

/*
  See TclBin(3)
*/

typedef  int     tfunc_obj _ANSI_ARGS_((ClientData clientData));


/* The object structure */
typedef struct Bin_Object {
#ifdef VERIFYSTRUCT
  unsigned int magic;    	/* magic number (integrity checking) */
#endif
  void   *data;          	/* pointer to actual data */
  size_t size;			/* data size (used for read/write & control) */
  struct Bin_Object *father;	/* father object (if object is a sub object) */
  char   *type;			/* type name   */
  size_t elemsize;		/* size of a single element (if applicable) */
  tfunc_obj *DeleteProc;	/* function to be called when deleting the
				 * object 
				 */
  Tcl_VarTraceProc *PeekPokeProc;/* tcl trace proc to be called 
				  * for reading/writing one element of 
				  * that type (if applicable) */
  Tcl_VarTraceProc *TraceProc; 	 /* tcl trace proc to be called for 
				  * reading/writing that type 
				  * (Bin_TraceObject(3) for plain objects
				  */
} Bin_Object;

/* to be used only when checking that an object doesn't already exists */
#define _BIN_GETOBJECT(interp,name) \
 ((Bin_Object *)Tcl_VarTraceInfo(interp,name,0,\
				 Bin_MainTraceProc,(ClientData)NULL))
     /* for tip */
#define _BIN_GETGLOBALOBJECT(interp,name) \
 ((Bin_Object *)Tcl_VarTraceInfo(interp,name,TCL_GLOBAL_ONLY,\
				 Bin_MainTraceProc,(ClientData)NULL))
#define _BIN_GETOBJECT2(interp,name1,name2) \
 ((Bin_Object *)Tcl_VarTraceInfo2(interp,name1,name2,0,\
				  Bin_MainTraceProc,(ClientData)NULL))


typedef struct Bin_TypeStruct {
#ifdef VERIFYSTRUCT
  unsigned int magic;  /* magic number */
#endif
  Tcl_VarTraceProc *TraceProc; /* tcl trace proc to be called for 
				  reading/writing that type */
  size_t size;  /* type size */
} Bin_TypeStruct;

#ifdef VERIFYSTRUCT
#define MAGIC_OBJ   0xff374562
#define MAGIC_TYP   0xff374661
#endif

/* Bin_TclAttach flags */
#define BIN_NO_FATHER_CHECK 1


EXTERN int Bin_Init _ANSI_ARGS_((Tcl_Interp *));

EXTERN int Bin_RegisterType _ANSI_ARGS_((Tcl_Interp *, Tcl_HashTable *, 
				       CONST char *, int, Tcl_VarTraceProc *));

EXTERN Tcl_HashTable *Bin_GetTHT _ANSI_ARGS_((Tcl_Interp *)) ;

EXTERN ClientData Bin_GetHashVal _ANSI_ARGS_((Tcl_HashTable *,CONST char *));

EXTERN int Bin_DefCmd _ANSI_ARGS_((ClientData, Tcl_Interp *,int , char **));

EXTERN int Bin_Def _ANSI_ARGS_((Tcl_HashTable *, Tcl_Interp *, CONST char *,
			        CONST char *,CONST char *,int,long));

EXTERN int Bin_SizeofType _ANSI_ARGS_((Tcl_HashTable *, Tcl_Interp *,
				       CONST char *));

EXTERN int Bin_TclAttach _ANSI_ARGS_((Tcl_Interp *, Bin_Object *,
				      CONST char *, CONST char *,int));

EXTERN int Bin_MoveCmd _ANSI_ARGS_((ClientData, Tcl_Interp *,int , char **));

EXTERN int Bin_ResizeCmd _ANSI_ARGS_((ClientData, Tcl_Interp *,int , char **));

EXTERN int Bin_NewCmd _ANSI_ARGS_((ClientData, Tcl_Interp *,int , char **));

EXTERN int Bin_CopyCmd _ANSI_ARGS_((ClientData, Tcl_Interp *,int , char **));

EXTERN int Bin_SizeofCmd _ANSI_ARGS_((ClientData, Tcl_Interp *,int , char **));

EXTERN int Bin_ReadCmd _ANSI_ARGS_((ClientData, Tcl_Interp *,int , char **));

EXTERN int Bin_InfoCmd _ANSI_ARGS_((ClientData, Tcl_Interp *,int , char **));

EXTERN int Bin_WriteCmd _ANSI_ARGS_((ClientData, Tcl_Interp *,int , char **));

EXTERN int Mat_NewMatrixCmd _ANSI_ARGS_((ClientData, Tcl_Interp *,int , 
					 char **));

EXTERN Bin_Object *Bin_GetObject _ANSI_ARGS_((Tcl_Interp *,CONST char*));

EXTERN Bin_Object *Bin_GetObjectAndCheck _ANSI_ARGS_((Tcl_Interp *,
						  CONST char*,CONST char *));

EXTERN Bin_Object *Bin_NewObject _ANSI_ARGS_((void *,int,Bin_Object *,
					      CONST char*,Tcl_VarTraceProc *));

EXTERN void Bin_DeleteObject _ANSI_ARGS_((Bin_Object *));


EXTERN CONST char *Bin_GenerateName _ANSI_ARGS_((CONST char *));

EXTERN char *Bin_TraceObject _ANSI_ARGS_((ClientData, Tcl_Interp *, char *,
					  char *, int));

EXTERN char *Bin_MainTraceProc _ANSI_ARGS_((ClientData, Tcl_Interp *, char *,
					    char *, int));

EXTERN char *Bin_TraceChar _ANSI_ARGS_((ClientData, Tcl_Interp *, char *,
					char *, int));

EXTERN char *Bin_TraceInt _ANSI_ARGS_((ClientData, Tcl_Interp *, char *,
				       char *, int));

EXTERN char *Bin_TraceNetInt _ANSI_ARGS_((ClientData, Tcl_Interp *, char *,
					  char *, int));

EXTERN char *Bin_TraceShort _ANSI_ARGS_((ClientData, Tcl_Interp *, char *,
					 char *, int));

EXTERN char *Bin_TraceNetShort _ANSI_ARGS_((ClientData, Tcl_Interp *, char *,
					    char *, int));

EXTERN char *Bin_TraceDouble _ANSI_ARGS_((ClientData, Tcl_Interp *, char *,
					  char *, int));

EXTERN char *Bin_TraceComplex _ANSI_ARGS_((ClientData, Tcl_Interp *, char *,
					   char *, int));

EXTERN char *Bin_TraceFloat _ANSI_ARGS_((ClientData, Tcl_Interp *, char *,
					 char *, int));

EXTERN char *Bin_TracePtr _ANSI_ARGS_((ClientData, Tcl_Interp *, char *,
				       char *, int));

EXTERN char *Bin_TraceStr _ANSI_ARGS_((ClientData, Tcl_Interp *, char *,
				       char *, int));

EXTERN char *Bin_FreeChild _ANSI_ARGS_((ClientData, Tcl_Interp *, char *,
					char *, int));


#ifndef MIN
#define MIN(a,b) ((a)<(b)?(a):(b))
#endif
#ifndef MAX
#define MAX(a,b) ((a)>(b)?(a):(b))
#endif

#ifndef HAVE_LTOA
EXTERN char *ltoa _ANSI_ARGS_((long));
#endif

#ifndef HAVE_MEMMOVE
#  define memmove(dest,source,length) bcopy(source,dest,length)
#endif

/* we should define a memset replacement if it does not exists 
 * but tcl itself would not build... 
 */
/*
#ifndef HAVE_MEMSET
#  define memset(dest,char,length) xxx
#endif
*/

#endif
